/*
 * @(#)OptionsPanel.java  1.0.1  2006-05-18
 *
 * Copyright (c) 2006 Lucerne University of Applied Sciences and Arts (HSLU)
 * Zentralstrasse 18, Postfach 2858, CH-6002 Lucerne, Switzerland
 * All rights reserved.
 *
 * The copyright of this software is owned by the Lucerne University of Applied 
 * Sciences and Arts (HSLU). You may not use, copy or modify this software, 
 * except in accordance with the license agreement you entered into with HSLU. 
 * For details see accompanying license terms. 
 */

package ch.hslu.cm;

import ch.randelshofer.html.ExtendedHTMLEditorKit;
import javax.swing.*;
import javax.swing.event.UndoableEditListener;
import javax.swing.text.html.*;
import java.util.*;
import org.jhotdraw.util.ResourceBundleUtil;
/**
 * OptionsPanel.
 *
 * @author Werner Randelshofer
 * @version 1.0.1 2006-05-18 Added workaround to support copy paste from
 * Microsoft Word.
 * <br>1.0 24. Februar 2006 Created.
 */
public class OptionsPanel extends javax.swing.JPanel {
    private ResourceBundleUtil labels;
    
    /** Creates new form. */
    public OptionsPanel() {
        labels = ResourceBundleUtil.getBundle("ch.hslu.cm.Labels");
        initComponents();
        
        instructionsField.setEditorKit(new ExtendedHTMLEditorKit());
        
        // Workaround for Bug ID:  4765240
        // http://bugs.sun.com/bugdatabase/view_bug.do?bug_id=4765240
        instructionsField.getDocument().putProperty("IgnoreCharsetDirective",
                Boolean.TRUE);
        
/*
        action = new DefaultEditorKit.InsertContentAction();
        action.putValue(Action.ACTION_COMMAND_KEY, "<BR>");
         keyStroke = KeyStroke.getKeyStroke(KeyEvent.VK_ENTER, 0);
        map.removeKeyStrokeBinding(keyStroke);
        map.addActionForKeyStroke(keyStroke, action);
 
        keyStroke = KeyStroke.getKeyStroke(KeyEvent.VK_ENTER, 0);
        map.removeKeyStrokeBinding(keyStroke);
        map.addActionForKeyStroke(keyStroke, new HTMLEditorKit.InsertBreakAction());
 */
        DefaultComboBoxModel cbm = new DefaultComboBoxModel(new Object[] {
            Locale.ENGLISH,
            Locale.GERMAN,
            Locale.FRENCH,
            Locale.ITALIAN,
        });
        languageCombo.setModel(cbm);
        clear();
    }
    
    public String getInstructionsText() {
        String txt = instructionsField.getText();
        // return Strings.replace(txt, "\n\n", "<br></br>");
        return txt;
    }
    /**
     * This method is thread safe, although most Swing methods are not.
     */
    public void setInstructionsText(String text) {
        instructionsField.setText(text);
    }
    public Locale getInstructionLanguage() {
        return (Locale) languageCombo.getSelectedItem();
    }
    /**
     * This method is thread safe, although most Swing methods are not.
     */
    public void setInstructionLanguage(Locale newValue) {
        languageCombo.setSelectedItem((newValue));
    }
    /**
     * Returns the content of the HTML Body element.
     */
    public String getInstructionsTextBodyContent() {
        // Extract body tag
        String html = getInstructionsText();
        int p1 = html.indexOf("<body");
        if (p1 == -1) {
            p1 = html.indexOf("<BODY>");
        }
        if (p1 != -1) {
            p1 = html.indexOf('>', p1);
        }
        int p2 = html.indexOf("</body>");
        if (p2 == -1) {
            p2 = html.indexOf("</BODY>");
        }
        if (p1 != -1 && p2 != -1) {
            html = html.substring(p1 + 1, p2);
        }
        
        // Insert &nbsp; into empty <p> tags
        p1 = html.indexOf("<p>");
        while (p1 != -1) {
            p2 = html.indexOf("</p>", p1);
            if (p2 != -1 && html.substring(p1+3,p2).trim().length() == 0) {
                html = html.substring(0, p1)+"<p>&nbsp;"+html.substring(p2);
            }
        p1 = html.indexOf("<p>", p1 + 3);
        }
        
        
        return html;
    }
    /**
     * Returns the HTML element, without leading and trealing elements.
     */
    public String getInstructionsTextHTML() {
        String html = getInstructionsText();
        //html = Strings.replace(html, "\n", "<br></br>");
        String htmlLC = html.toLowerCase();
        
        int p1 = htmlLC.indexOf("<html");
        if (p1 != -1) {
            p1 = htmlLC.indexOf('>', p1);
        }
        int p2 = htmlLC.indexOf("</html>");
        if (p1 == -1 || p2 == -1) {
            return html;
        } else {
            return "<html>"+html.substring(p1 + 1, p2)+"</html>";
        }
    }
    
    
    public String getChapterText() {
        return chapterField.getText();
    }
    /**
     * This method is thread safe, although most Swing methods are not.
     */
    public void setChapterText(String text) {
        chapterField.setText(text);
    }
    public String getTitleText() {
        return titleField.getText();
    }
    /**
     * This method is thread safe, although most Swing methods are not.
     */
    public void setTitleText(String text) {
        titleField.setText(text);
    }
    
    public void addUndoableEditListener(UndoableEditListener l) {
        chapterField.getDocument().addUndoableEditListener(l);
        titleField.getDocument().addUndoableEditListener(l);
        instructionsField.getDocument().addUndoableEditListener(l);
    }
    public void removeUndoableEditListener(UndoableEditListener l) {
        chapterField.getDocument().removeUndoableEditListener(l);
        titleField.getDocument().removeUndoableEditListener(l);
        instructionsField.getDocument().removeUndoableEditListener(l);
    }
    
    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {

        instructionsLabel = new javax.swing.JLabel();
        jScrollPane1 = new javax.swing.JScrollPane();
        instructionsField = new javax.swing.JTextPane();
        titleLabel = new javax.swing.JLabel();
        titleField = new javax.swing.JTextField();
        chapterLabel = new javax.swing.JLabel();
        chapterField = new javax.swing.JTextField();
        languageLabel = new javax.swing.JLabel();
        languageCombo = new javax.swing.JComboBox();

        instructionsLabel.setText(labels.getString("studentInstructionsLabel")); // NOI18N

        instructionsField.setEditorKit(new HTMLEditorKit());
        jScrollPane1.setViewportView(instructionsField);

        titleLabel.setText(labels.getString("title")); // NOI18N

        chapterLabel.setText(labels.getString("chapter")); // NOI18N

        languageLabel.setText(labels.getString("language")); // NOI18N

        javax.swing.GroupLayout layout = new javax.swing.GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(layout.createSequentialGroup()
                .addContainerGap()
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addComponent(jScrollPane1, javax.swing.GroupLayout.DEFAULT_SIZE, 310, Short.MAX_VALUE)
                    .addComponent(instructionsLabel)
                    .addComponent(titleField, javax.swing.GroupLayout.DEFAULT_SIZE, 310, Short.MAX_VALUE)
                    .addComponent(chapterLabel)
                    .addComponent(titleLabel)
                    .addComponent(chapterField, javax.swing.GroupLayout.DEFAULT_SIZE, 310, Short.MAX_VALUE)
                    .addGroup(layout.createSequentialGroup()
                        .addComponent(languageLabel)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addComponent(languageCombo, 0, 241, Short.MAX_VALUE)))
                .addContainerGap())
        );
        layout.setVerticalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(layout.createSequentialGroup()
                .addContainerGap()
                .addComponent(chapterLabel)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(chapterField, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(titleLabel)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(titleField, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(instructionsLabel)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(jScrollPane1, javax.swing.GroupLayout.DEFAULT_SIZE, 179, Short.MAX_VALUE)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(languageLabel)
                    .addComponent(languageCombo, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
                .addContainerGap())
        );
    }// </editor-fold>//GEN-END:initComponents
    
    public void clear() {
        setTitleText("");
        setChapterText("");
        instructionsField.setText(labels.getString("studentInstructionsWriteHere"));
        languageCombo.setSelectedIndex(0);
    }
    
    
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JTextField chapterField;
    private javax.swing.JLabel chapterLabel;
    private javax.swing.JTextPane instructionsField;
    private javax.swing.JLabel instructionsLabel;
    private javax.swing.JScrollPane jScrollPane1;
    private javax.swing.JComboBox languageCombo;
    private javax.swing.JLabel languageLabel;
    private javax.swing.JTextField titleField;
    private javax.swing.JLabel titleLabel;
    // End of variables declaration//GEN-END:variables
    
}
